<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Controllers\Controller;
use App\DTOs\Trademarks\TrademarkCreateDto;
use App\DTOs\Trademarks\TrademarkUpdateDto;
use App\Repositories\Interfaces\ITrademarkRepository;

class TrademarkController extends Controller
{

    private $trademarkRepository;

    public function __construct(ITrademarkRepository $trademarkRepository)
    {
        $this->trademarkRepository = $trademarkRepository;
    }

    public function index(Request $request)
    {
        return $this->trademarkRepository->paginate($request->all());
    }

    public function show(int $id)
    {
        $result = $this->trademarkRepository->find($id);

        if ($result) {
            //return $result;
            return $this->successResponse($result, "Marca encontrada correctamente", 201);
        } else {
            return $this->errorResponse("Marca no encontrada", 201);
        }

        //return response('Almacen no encontrado', 404);
    }

    public function store(Request $request)
    {
        try {
            $this->validate($request, [
                'code' => 'required|unique:tec_trademarks|max:10',
                'trademark' => 'required|max:250'
            ]);

            $store = new TrademarkCreateDto($request->except('business_information'));
            $result = $this->trademarkRepository->store($store);
    
            return $this->successResponse($result, "Marca creada correctamente", 201);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }        
      
        //return response($result, 201);
    }

    public function update(int $id, Request $request)
    {
        try {
            $this->validate($request, [
                'code' => [
                    'required',
                    Rule::unique('tec_trademarks')->ignore($id),
                    'max:10'
                ],
                'trademark' => 'required|max:250'
            ]);
    
            $data = $request->except('business_information');
            $data['id'] = $id;
    
            $entry = new TrademarkUpdateDto($data);
    
            $this->trademarkRepository->update($entry);

            $result = $this->trademarkRepository->find($id);

            return $this->successResponse($result, "Marca actualizada correctamente", 201);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return $this->errorResponse($e->response->original, 201);
        }

        //return response(null, 202);
    }

    public function destroy(int $id)
    {
        $result = $this->trademarkRepository->find($id);

        if ($result) {
            $this->trademarkRepository->destroy($id);

            return $this->successResponse($id, "Marca eliminada correctamente", 201);    
        } else {
            return $this->errorResponse("Marca ingresada no existe", 201);
        }

        //return response(null, 202);
    }    
}
