<?php
/**
 * Created by PhpStorm.
 * User: juan
 * Date: 13/1/2021
 * Time: 13:08
 */

namespace App\Traits;

use Illuminate\Database\Eloquent\Model;

trait Responser
{
    protected function successResponse($data,$message,$code){
        return response()->json(["result"=>"ok","data"=>$data, "message"=>$message],$code);
    }

    protected function errorResponse($message,$code){
        return response()->json(["result"=>"failed","message"=>$message,"code"=>$code],$code);
    }

    protected function dataArrayResponse(array $data, $code){
        return response()->json(["result"=>"ok", "data"=>$data, "code"=>$code], $code);
    }

    protected function showModel(Model $instance, $message, $code = 200){
        return $this->successResponse(["data"=>$instance], $message, $code);
    }

    protected function showCollectJsonAll(Array $collection, $count = 0, $code = 200){
        if( empty($collection['data']) ){
            //if($count>0){
            return $this->successResponse(["data"=>$collection], "", $code);
            // }else{
            // return $this->errorResponse(["data"=>$collection], $code);
            // }
        }

        // if($count>0){
        return $this->successResponse(["data"=>$collection], "", $code);
        // }else{
        // return $this->errorResponse(["data"=>$collection], $code);
        // }
    }

    protected function messageSuccess($message,$code=200){
        return $this->successResponse([], $message,$code);
    }

    protected function messageError($message,$code){
        return $this->errorResponse($message,$code);
    }

    protected function messageSuccessInsert($message,$code){
        return $this->successResponse([], $message,$code);
    }

    protected function resultArrayData($data,$code){
        return $this->dataArrayResponse(["data"=>$data],$code);
    }
}