<?php

namespace App\Http\Controllers;

use App\EmpresaModel;
use App\AjusteModel;
use App\Traits\ApiResponser;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Rules\DatosEmpresa;
use App\Http\Controllers\cpanel\cPanel\cPanel;
use App\Http\Controllers\Execute_file_sql;
use App\Http\Controllers\Editor_file;
use App\Http\Controllers\Send_mail;
use App\Http\Controllers\EncriptadorTPV;
use App\Http\Controllers\LogCpanel;

class EmpresaController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
      use ApiResponser;
      
    /**
     * Create a new controller instance.
     *
     * @return void
     */

    public function __construct()
    {
        
       /* $this->middleware('auth',['only'=>[
            'store','update','delete'
        ]]);*/
    }

    public  function listarEmpresas(){
        $business= new EmpresaModel();
        $business=$business ->getBusiness();


        return $business;
    }
    public function registrarEmpresa(Request $request){
        //$response=$request;
        //return $response;
        $data=$request->all();
       // return $data;
        if($data['tip_persona']==2){
            $this->validate($request,['num_documento'=>'digits:11'],['El ruc debe contener 11 digitos']);
        }else
        {
            if($data['id_tip_doc']==1){//dni
                $this->validate($request,['num_documento'=>'digits:8'],['El DNI debe contener 8 digitos']);
            }else if($data['id_tip_doc']==2){//carnet de extrangeria
                $this->validate($request,['num_documento'=>'digits:12'],['En carnet de ext. debe contener 12 digitos']);
            }
            else if($data['id_tip_doc']==3){//ruc
                $this->validate($request,['num_documento'=>'digits:11'],['El RUC debe contener 8 digitos']);
            }
            else if($data['id_tip_doc']==4){
                $this->validate($request,['num_documento'=>'digits:8'],['El pasaporte debe contener 12 digitos']);
            }
            else {
                $this->validate($request,['num_documento'=>'digits:15'],['El :attribute de ext. debe contener 8 digitos']);
            }
        }
        if($data['id_tip_doc_contacto']==1){//dni
            $this->validate($request,['num_documento_contacto'=>'digits:8'],['El DNI del contacto debe contener 8 digitos']);
        }else if($data['id_tip_doc_contacto']==2){//carnet de extrangeria
            $this->validate($request,['num_documento_contacto'=>'digits:12'],['El carnet del contacto de ext. debe contener 12 digitos']);
        }
        else if($data['id_tip_doc_contacto']==3){//ruc
            $this->validate($request,['num_documento_contacto'=>'digits:11'],['El RUC del contacto debe contener 8 digitos']);
        }
        else if($data['id_tip_doc_contacto']==4){
            $this->validate($request,['num_documento_contacto'=>'digits:8'],['El pasaporte del contacto debe contener 12 digitos']);
        }
        else {
            $this->validate($request,['num_documento_contacto'=>'digits:15'],['El :attribute del contacto de ext. debe contener 8 digitos']);
        }
        $rules=[
            'ruc'=>'digits:11',
            'nombres'=>'required|max:255',
            'direccion'=>'max:255', 
            'ape_paterno'=>'max:20',
            'ape_materno'=>'max:20', 
            'ape_paterno_contacto'=>'max:20',
            'ape_materno_contacto'=>'max:20', 
            'email1_contacto'=>'email',
            'email2_contacto'=>'email',         
        ];
        
        $this->validate($request,$rules,$this->mensajes());
		
		//$this->validate($request,$rules,$messages);
		$data=$request->all();
				
		$datos_ajustes=new AjusteModel();
		$datos_ajustes=$datos_ajustes->ListarAjustes();
				
		foreach($datos_ajustes as $dato_ajuste){
			$asjute['USER_HOST']=$dato_ajuste->USER_HOST;
			$asjute['PASS_HOST']=$dato_ajuste->PASS_HOST;
			$asjute['IP_HOST']=$dato_ajuste->IP_HOST;
			$asjute['HOST_HOST']=$dato_ajuste->HOST_HOST;
			$asjute['FILE_SISTEM']='../system_TPV/app';//$dato_ajuste->FILE_SISTEM;
			$asjute['PREFIJO_DATABASE']=$dato_ajuste->PREFIJO_DATABASE;
			$asjute['FILE_SQL_SISTEM_TPV']='../system_TPV/database.sql';//$dato_ajuste->FILE_SQL_SISTEM_TPV;
			$asjute['FILE_DATABASE_part1']=$dato_ajuste->ubicacion_sub_dominio;
			//$asjute['FILE_DATABASE_part2']=$dato_ajuste->FILE_DATABASE_part2;
			$asjute['mail_host']=$dato_ajuste->mail_host;
			$asjute['mail_port']=$dato_ajuste->mail_port;
			$asjute['mail_user']=$dato_ajuste->mail_user;
			$asjute['mail_password']=$dato_ajuste->mail_password;
			$asjute['file_ws_pse']=$dato_ajuste->file_ws_pse;
			$asjute['ws_pse']=$dato_ajuste->ws_pse;
			$asjute['ws_ventas']=$dato_ajuste->ws_ventas;
			$asjute['ws_almacen']=$dato_ajuste->ws_almacen;
			$asjute['ws_general']=$dato_ajuste->ws_general;
		}
				
		$dataBD=$this->generaAccesoBD($data['subdominio'], $data['num_documento'], $asjute['PREFIJO_DATABASE']);
		//return $dataBD;
		$data['host_db']=$asjute['IP_HOST'];
		$data['db_sistema']=$dataBD['name_BD'];
		$data['user_db']=$dataBD['userBD'];
		$data['password_db']=$dataBD['var_passDB'];
				
		//$subDominio_name=strstr($data['subdominio'], '.', true);
		$subDominio_name=$data['subdominio'];
				
		//*******************registrar en BD**************************
        $business = new EmpresaModel();
        $res=$business->insertBusiness($data);
		
		if(strpos($res[0], 'ya existe') == false){
			
				$log = new LogCpanel($data['num_documento']);
				
				$result_subDominio = $this->creacion_SUB_dominio($subDominio_name, $asjute['FILE_DATABASE_part1']);
				
				if($result_subDominio['status']==0){
					
					$result['subDominio']=str_replace("“","'",str_replace ( "”" , "'" , $result_subDominio['errors']));
					
					$rest= json_encode($result);
					$log->edit_log_error('creacion de sub-dominio', $result['subDominio'][0]);
					return $rest;
					
				}
				$log->edit_log_success('creacion de sub-dominio');
				
				//$this->copiar_archivos(env("FILE_SISTEM"), "C:\Users\AlexanderRoca\Desktop\Nueva carpeta");
				$result_copy = $this->copiar_archivos($asjute["FILE_SISTEM"], $asjute['FILE_DATABASE_part1'] .'/'.$subDominio_name);
				if($result_copy == 0){
					
					$result['copy_file_System']=array("error al copiar los archivos del sistema");
					
					$rest= json_encode($result);
					$log->edit_log_error('copiar archivos de sistema', $result['copy_file_System'][0]);
					return $rest;
					
				}
				$log->edit_log_success('copiar archivos de sistema');
				
				$result_carpeta_pse = $this->creacion_carpetas_pse($asjute['file_ws_pse'], $data['num_documento']);
				if($result_carpeta_pse < 5){
					
					$result['create_directory_pse']=array("error al crear carpetas del pse");
					
					$rest= json_encode($result);
					$log->edit_log_error('crear carpetas para el pse', $result['create_directory_pse'][0]);
					return $rest;
					
				}
				$log->edit_log_success('crear carpetas para el pse');
				
				$result_BD = $this->creacion_dataBase($data['db_sistema']);
				
				if($result_BD['status']==0){
					
					$result['data_base']=str_replace("“","'",str_replace ( "”" , "'" , $result_BD['errors']));
					
					$rest= json_encode($result);
					$log->edit_log_error('creacion de base de datos', $result['data_base'][0]);
					return $rest;
					
				}
				$log->edit_log_success('creacion de base de datos');
				
				$result_user_BD = $this->creacion_user_db($data['user_db'], $data['password_db']);
				
				if($result_user_BD['status']==0){
					
					$result['user_data_base']=str_replace("“","'",str_replace ( "”" , "'" , $result_user_BD['errors']));
					
					$rest= json_encode($result);
					$log->edit_log_error('creacion de usuario de base de datos', $result['user_data_base'][0]);
					return $rest;
					
				}
				$log->edit_log_success('creacion de usuario de base de datos');
				
				$result_user_BD_privi = $this->privilegios_user_db($data['user_db'], $data['db_sistema']);
				
				if($result_user_BD_privi['status']==0){
					
					$result['user_data_base_privilegios']=str_replace("“","'",str_replace ( "”" , "'" , $result_user_BD_privi['errors']));
					
					$rest= json_encode($result);
					$log->edit_log_error('asignacion privilegios de usuario de base de datos', $result['user_data_base_privilegios'][0]);
					return $rest;
					
				}
				$log->edit_log_success('asignacion privilegios de usuario de base de datos');
				
				$datos_insert = array(
				'username' => $data['subdominio'],
				'password' => $this->generar_password($data['subdominio'] ."_". $data['num_documento']),
				'email' => $data['email1_contacto'],
				'first_name' => $data['nombre_contacto'],
				'last_name' => $data['ape_paterno_contacto'] ." ". $data['ape_materno_contacto'],
				'phone' => $data['movil1_contacto']
				);
				
				$result_exe_SQL = $this->ejecutar_archivo_sql(env("DB_HOST"), $data['user_db'], $data['password_db'], 
				$data['db_sistema'], $asjute["FILE_SQL_SISTEM_TPV"],$datos_insert, $data['nombres'], 
				$data['num_documento'], $asjute['file_ws_pse'], $data['direccion'], $data['region'], $data['pais']);
				
				if($result_exe_SQL == 0){
					
					$result['execute_file_SQL']=array("error al ejecutar archivo SQL");
					
					$rest= json_encode($result);
					$log->edit_log_error('ejecicion de query creador de DB sistema_TPV', $result['execute_file_SQL'][0]);
					return $rest;
					
				}
				$log->edit_log_success('ejecicion de query creador de DB sistema_TPV');
				
				//$archivo=$asjute["FILE_DATABASE_part1"] .'/'. $subDominio_name. '/app/config/database.php';
				$archivo=$asjute["FILE_DATABASE_part1"] .'/'. $subDominio_name;
				
				$edit_file = $this->edicion_archivo($archivo, $asjute['IP_HOST'], $data['user_db'], $data['password_db'], 
				$data['db_sistema'],$asjute['ws_pse'],$asjute['ws_ventas'],$asjute['ws_almacen'],$asjute['ws_general']);
				
				if($edit_file == 0){
					
					$result['edit_file_system']=array("error al editar archivos del sistema");
					
					$rest= json_encode($result);
					$log->edit_log_error('edicion de archivos de configuracion del sistema_TPV', $result['edit_file_system'][0]);
					return $rest;
					
				}
				$log->edit_log_success('edicion de archivos de configuracion del sistema_TPV');
				//******************envio de correo de confirmacion *****************
				$envio_correo = new Send_mail($asjute['mail_host'], $asjute['mail_port'], $asjute['mail_user'], $asjute['mail_password']);
				
				$mensaje="se genero con exito su sistema TPV, para acceder debe de usar los siguientes datos: <br><br>".
						 " URL: http://". $data['subdominio'] .".".$asjute['HOST_HOST']. "<br>".
						 " USUARIO: ". $datos_insert['email'] . "<br>".
						 " PASSWORD: ". $data['subdominio'] ."_". $data['num_documento'] .
						 "<br><br><br>Atte. SISTEMA TPV";
				$nombre_destinatario = $data['nombre_contacto']." ".$data['ape_paterno_contacto']." ".$data['ape_materno_contacto'];
				$asunto="Confirmacion de creacion de Sistema TPV";
				
				$resul_envio_email_1ero = $envio_correo->enviar_correo($mensaje, $data['email1_contacto'], $nombre_destinatario, $asunto);
				
				if($resul_envio_email_1ero == 0){
					
					$result['primer_send_mail']=array("error al enviar el primer correo de confirmacion");
					
					$rest= json_encode($result);
					$log->edit_log_error('envio de primer correo',$result['primer_send_mail'][0]);
					return $rest;
					
				}
				$log->edit_log_success('envio de primer correo');
				
				if($data['email2_contacto'] != "" && $data['email2_contacto'] != null){
				
					$resul_envio_email_2do = $envio_correo->enviar_correo($mensaje, $data['email2_contacto'], $nombre_destinatario, $asunto);
					
					if($resul_envio_email_2do == 0){
						
						$result['segundo_send_mail']=array("error al enviar el segundo correo de confirmacion");
						
						$rest= json_encode($result);
						$log->edit_log_error('envio de segundo correo',$result['segundo_send_mail'][0]);
						return $rest;
						
					}
					$log->edit_log_success('envio de segundo correo');
				
				}
				
		//return $this->SuccessResponse(array(array('var_mensaje'=>"mensaje de confirmacion")),Response::HTTP_OK);
        //return $this->ErrorResponse("mensaje error",Response::HTTP_INTERNAL_SERVER_ERROR);//$res;
		}
		
		return $res[1];
		
    }
    public function generaAccesoBD($subdominio, $ruc, $PREFIJO_DATABASE){
		
        //$name_BD= strstr($subdominio, '.', true);
		$name_BD= $subdominio;
        
        $permitted_chars = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $aleatorio=substr(str_shuffle($permitted_chars), 0, 4);
        if(strlen ($name_BD)>10){
            $name_BD=substr($name_BD, 0, 10);
        }
		 
         $userBD=$PREFIJO_DATABASE."u_".$ruc;
         $var_passDB = $name_BD.$aleatorio;
		 $name_BD=$PREFIJO_DATABASE."db_".$ruc;
         
         $data=array(
             'name_BD'=>$name_BD,
             'userBD'=>$userBD,
             'var_passDB'=>$var_passDB
         );
        return $data;
    }
    public function listaraxId($id){


       $business= new EmpresaModel();
       $business=$business->listarEmpresasPorId($id);
        return $business;
    }

    public function listarPorRuc($ruc){

        
        $business= new EmpresaModel();
        $business=$business->listarEmpresasPorRUC($ruc);
         
 
         return $business;
     }
    public function actualizarEmpresa(Request $request,$id){
        $data=$request->all();
        if($data['tip_persona']==2){
            $this->validate($request,['num_documento'=>'digits:11'],['El ruc debe contener 11 digitos']);
        }else
        {
            if($data['id_tip_doc']==1){//dni
                $this->validate($request,['num_documento'=>'digits:8'],['El DNI debe contener 8 digitos']);
            }else if($data['id_tip_doc']==2){//carnet de extrangeria
                $this->validate($request,['num_documento'=>'digits:12'],['En carnet de ext. debe contener 12 digitos']);
            }
            else if($data['id_tip_doc']==3){//ruc
                $this->validate($request,['num_documento'=>'digits:11'],['El RUC debe contener 11 digitos']);
            }
            else if($data['id_tip_doc']==4){
                $this->validate($request,['num_documento'=>'digits:8'],['El pasaporte debe contener 12 digitos']);
            }
            else {
                $this->validate($request,['num_documento'=>'digits:15'],['El :attribute de ext. debe contener 8 digitos']);
            }
        }
        if($data['id_tip_doc_contacto']==1){//dni
            $this->validate($request,['num_documento_contacto'=>'digits:8'],['El DNI del contacto debe contener 8 digitos']);
        }else if($data['id_tip_doc_contacto']==2){//carnet de extrangeria
            $this->validate($request,['num_documento_contacto'=>'digits:12'],['El carnet del contacto de ext. debe contener 12 digitos']);
        }
        else if($data['id_tip_doc_contacto']==3){//ruc
            $this->validate($request,['num_documento_contacto'=>'digits:11'],['El RUC del contacto debe contener 8 digitos']);
        }
        else if($data['id_tip_doc_contacto']==4){
            $this->validate($request,['num_documento_contacto'=>'digits:8'],['El pasaporte del contacto debe contener 12 digitos']);
        }
        else {
            $this->validate($request,['num_documento_contacto'=>'digits:15'],['El :attribute del contacto de ext. debe contener 8 digitos']);
        }
        $rules=[
            'ruc'=>'digits:11',
            'nombres'=>'required|max:255',
            'direccion'=>'max:255', 
            'ape_paterno'=>'max:20',
            'ape_materno'=>'max:20', 
            'ape_paterno_contacto'=>'max:20',
            'ape_materno_contacto'=>'max:20', 
            'email1_contacto'=>'email',
            'email2_contacto'=>'email',         
        ];
        
        $this->validate($request,$rules,$this->mensajes());
        $business= new EmpresaModel();
        $business=$business->updateBusiness($request,$id);
        return $business;
    }
    public function  eliminarEmpresa($id){
        $business= new EmpresaModel();
        $business=$business->deleteBusiness($id);
        return $business;


    }
    
	public function mensajes(){
		return [
				
				'nombres.required' =>'El :attribute es requerido.',
				'nombres.max' =>'El :attribute es requerido.',
				'direccion.max' =>'La :attribute no es válida.',
				'ape_paterno.max' =>'El apellido paterno no es valido.',
				'ape_materno.max' =>'El apellido materno no es valido.',
				'ape_paterno_contacto.max' =>'El apellido paterno del contacto no es valido.',
				'ape_materno_contacto.max' =>'El apellido materno del contacto no es valido.',
				'email1_contacto.email'=>'el email del contacto debe ser una dirección de correo válido.',
				'email2_contacto.email'=>'el segundo email  del contacto debe ser una dirección de correo válido.'
				];
	}
	
	public function creacion_SUB_dominio($NAMEsubdominio, $contenedor_subDominio){
		
		//include(__DIR__.'/../../../../plugin/cpanel/cPanel/cPanel.php');
		//require __DIR__.'/../../../plugin/cpanel/cPanel/cPanel.php';
		
		/*if(file_exists($contenedor_subDominio)){
			$existe_carpeta=1;
		}else{
			if(mkdir($contenedor_subDominio, 0777, true)){
				$existe_carpeta=1;
			}else{
				$existe_carpeta=0;
			}
		}
		
		if($existe_carpeta==1){*/
			
			$datos_ajustes=new AjusteModel();
			$datos_ajustes=$datos_ajustes->ListarAjustes();
			
			foreach($datos_ajustes as $dato_ajuste){
				$asjute['USER_HOST']=$dato_ajuste->USER_HOST;
				$asjute['PASS_HOST']=$dato_ajuste->PASS_HOST;
				$asjute['IP_HOST']=$dato_ajuste->IP_HOST;
				$asjute['HOST_HOST']=$dato_ajuste->HOST_HOST;
			}

			$username=$asjute["USER_HOST"];
			$password=$asjute["PASS_HOST"];
			$host=$asjute["IP_HOST"];
			
			$cpanel = new CPANEL($username, $password, $host);

			$get_userdata = $cpanel->uapi(
				'SubDomain', 'addsubdomain',
					array(
					'domain'                => $NAMEsubdominio,
					'rootdomain'            => $asjute["HOST_HOST"],
					'dir'                   => $contenedor_subDominio . '/' . $NAMEsubdominio,
					'disallowdot'           => '1',
				)
			);
			
			foreach($get_userdata as $nombre => $valor){
				if($nombre =='status'){
					$status=$valor;
				}
				if($nombre =='errors'){
					$error=$valor;
				}
			}
			
			$respuesta['status']=$status;
			$respuesta['errors']=$error;
			
		/*}else{
			$respuesta['status']=0;
			$respuesta['errors']=array( 0 => 'error al crear contendor de sub-dominio');
		}*/
		
		return $respuesta;
		
	}
	
	public function copiar_archivos($fuente, $destino){
		
		$sensor=1;
		
		if(is_dir($fuente)){
			$dir=opendir($fuente);
			while($archivo=readdir($dir))
			{
				if($archivo!="." && $archivo!="..")
				{
					if(is_dir($fuente."/".$archivo))
					{
						if(!is_dir($destino."/".$archivo))
						{
							if(!@mkdir($destino."/".$archivo)){//;
								//echo "no se pudo crear la carpeta <br>";
								$sensor=0;
							}else{
								//echo "se pudo crear la carpeta <br>";
								$sensor=1;
							}
						}
						$this->copiar_archivos($fuente."/".$archivo, $destino."/".$archivo);
						//copiar_archivos($fuente."/".$archivo, $destino."/".$archivo);
					}
					else
					{
						if(!@copy($fuente."/".$archivo, $destino."/".$archivo)){//;
							//echo "1 no se pudo copiar <br>";
							$sensor=0;
						}else{
							//echo "1 se pudo copiar <br>";
							$sensor=1;
						}
					}
				}
			}
			closedir($dir);
		}else{
			if(!@copy($fuente, $destino)){//;
				//echo "2 no se pudo copiar <br>";
				$sensor=0;
			}else{
				//echo "2 se pudo copiar <br>";
				$sensor=1;
			}
		}
		
		return $sensor;
	}
	
	public function creacion_dataBase($name_dataBase){
		
		$datos_ajustes=new AjusteModel();
		$datos_ajustes=$datos_ajustes->ListarAjustes();
		
		foreach($datos_ajustes as $dato_ajuste){
			$asjute['USER_HOST']=$dato_ajuste->USER_HOST;
			$asjute['PASS_HOST']=$dato_ajuste->PASS_HOST;
			$asjute['IP_HOST']=$dato_ajuste->IP_HOST;
		}
		
		$username=$asjute["USER_HOST"];
		$password=$asjute["PASS_HOST"];
		$host=$asjute["IP_HOST"];
		
		$cpanel = new CPANEL($username, $password, $host);

		$create_db = $cpanel->uapi(
			'Mysql', 'create_database',
			array(
				'name'    => $name_dataBase,
			)
		);
		
		foreach($create_db as $nombre => $valor){
			if($nombre =='status'){
				$status=$valor;
			}
			if($nombre =='errors'){
				$error=$valor;
			}
		}
		
		$respuesta['status']=$status;
		$respuesta['errors']=$error;
		
		return $respuesta;
		
	}
	
	public function creacion_user_db($db_user, $db_password){
		
		$datos_ajustes=new AjusteModel();
		$datos_ajustes=$datos_ajustes->ListarAjustes();
		
		foreach($datos_ajustes as $dato_ajuste){
			$asjute['USER_HOST']=$dato_ajuste->USER_HOST;
			$asjute['PASS_HOST']=$dato_ajuste->PASS_HOST;
			$asjute['IP_HOST']=$dato_ajuste->IP_HOST;
		}
		
		$username=$asjute["USER_HOST"];
		$password=$asjute["PASS_HOST"];
		$host=$asjute["IP_HOST"];
		
		$cpanel = new CPANEL($username, $password, $host);

		$create_user = $cpanel->uapi(
			'Mysql','create_user',
			array(
					'name' => $db_user,
					'password' => $db_password,
			)
		);
		
		foreach($create_user as $nombre => $valor){
			if($nombre =='status'){
				$status=$valor;
			}
			if($nombre =='errors'){
				$error=$valor;
			}
		}
		
		$respuesta['status']=$status;
		$respuesta['errors']=$error;
		
		return $respuesta;
		
	}
	
	public function privilegios_user_db($user, $data_base){
		
		$datos_ajustes=new AjusteModel();
		$datos_ajustes=$datos_ajustes->ListarAjustes();
		
		foreach($datos_ajustes as $dato_ajuste){
			$asjute['USER_HOST']=$dato_ajuste->USER_HOST;
			$asjute['PASS_HOST']=$dato_ajuste->PASS_HOST;
			$asjute['IP_HOST']=$dato_ajuste->IP_HOST;
		}
		
		$username=$asjute["USER_HOST"];
		$password=$asjute["PASS_HOST"];
		$host=$asjute["IP_HOST"];
		
		$cpanel = new CPANEL($username, $password, $host);

		$set_dbuser_privs = $cpanel->uapi(
			'Mysql', 'set_privileges_on_database',
			array(
				'user'       => $user,
				'database'   => $data_base,
				'privileges' => 'ALTER,ALTER ROUTINE,CREATE,CREATE ROUTINE,CREATE TEMPORARY TABLES,CREATE VIEW,DELETE,DROP,EVENT,EXECUTE,INDEX,INSERT,LOCK TABLES,REFERENCES,SELECT,SHOW VIEW,TRIGGER,UPDATE',
			)
		);
		
		foreach($set_dbuser_privs as $nombre => $valor){
			if($nombre =='status'){
				$status=$valor;
			}
			if($nombre =='errors'){
				$error=$valor;
			}
		}
		
		$respuesta['status']=$status;
		$respuesta['errors']=$error;
		
		return $respuesta;
		
	}
	
	public function ejecutar_archivo_sql($host, $user, $pass, $name_db, $ubi_file, $datos_insert, $razonSocial, $numDocument, $files_pse, $direccion, $region, $pais){
		
		$ejecutarSQL= new Execute_file_sql($host, $user, $pass, $name_db);
		
		$result_conexion = $ejecutarSQL->crear_conexion();
		
		if($result_conexion == 0){
			return $result_conexion;
		}
		
		$result = $ejecutarSQL->execute_sql($ubi_file, $datos_insert['username'], $datos_insert['password'], $datos_insert['email'],
		$datos_insert['first_name'], $datos_insert['last_name'], $datos_insert['phone'], $razonSocial, $numDocument, $files_pse, 
		$direccion, $region, $pais);
		
		$ejecutarSQL->cerrar_conexion();
		
		return $result;
		
	}
	
	/*public function insetar_usuario_standar($host, $user, $pass, $name_db, $datos_insert){
		
		$ejecutarSQL= new Execute_file_sql($host, $user, $pass, $name_db);
		
		$result_conexion = $ejecutarSQL->crear_conexion();
		
		if($result_conexion == 0){
			return $result_conexion;
		}
		
		$result = $ejecutarSQL->insert_user(
		$datos_insert['username'], $datos_insert['password'], $datos_insert['email'],
		$datos_insert['first_name'], $datos_insert['last_name'], $datos_insert['phone']);
		
		$ejecutarSQL->cerrar_conexion();
		
		return $result;
		
	}*/
	
	public function generar_password($password){
		$encript_pass= new EncriptadorTPV();
		
		return $encript_pass->hash_encript($password);
		
	}
	
	public function edicion_archivo($archivo, $host_name, $user, $password, $name_db,$ws_pse,$ws_ventas,$ws_almacen,$ws_general){
		
		
		$editar1 = new Editor_file($archivo.'/app/config/database.php');
		
		$result_file_abrir1 = $editar1->abrir_editor();
		
		if($result_file_abrir1 == 0){
			
			//$editar1->cerrar_editor();
			return $result_file_abrir1;
		}
		
		$result = $editar1->editar_file_database($host_name, $user, $password, $name_db);
		
		$editar1->cerrar_editor();
		
		if($result != 0){
			
			$editar2 = new Editor_file($archivo.'/app/config/config.php');
		
			$result_file_abrir2 = $editar2->abrir_editor();
			
			if($result_file_abrir2 == 0){
				
				//$editar2->cerrar_editor();
				return $result_file_abrir2;
			}
			
			$result = $editar2->editar_file_config($ws_pse,$ws_ventas,$ws_almacen,$ws_general);
			
			$editar2->cerrar_editor();
			
		}
		
		return $result;
		
	}
	
	public function creacion_carpetas_pse($ruta_base_pse, $ruc){
		
		$valid=0;
		
		if(file_exists($ruta_base_pse ."/". $ruc . "/CDR/BETA")){
			$valid++;
		}else{
			if(mkdir($ruta_base_pse ."/". $ruc . "/CDR/BETA", 0777, true)){
				$valid++;
			}
		}
		
		if(file_exists($ruta_base_pse ."/". $ruc . "/CDR/XML")){
			$valid++;
		}else{
			if(mkdir($ruta_base_pse ."/". $ruc . "/CDR/XML", 0777, true)){
				$valid++;
			}
		}
		
		if(file_exists($ruta_base_pse ."/". $ruc . "/CPE/BETA")){
			$valid++;
		}else{
			if(mkdir($ruta_base_pse ."/". $ruc . "/CPE/BETA", 0777, true)){
				$valid++;
			}
		}
		
		if(file_exists($ruta_base_pse ."/". $ruc . "/CPE/FIRMAXML")){
			$valid++;
		}else{
			if(mkdir($ruta_base_pse ."/". $ruc . "/CPE/FIRMAXML", 0777, true)){
				$valid++;
			}
		}
		
		if(file_exists($ruta_base_pse ."/". $ruc . "/CPE/XML")){
			$valid++;
		}else{
			if(mkdir($ruta_base_pse ."/". $ruc . "/CPE/XML", 0777, true)){
				$valid++;
			}
		}
		
		return $valid;
		
	}
}
