<?php 

namespace App\Models\MySQL\CodeyGenerateNoteCredit;

final class NoteCreditModel{
	
	/**
	* @var int
	*/
	private $id;
	
	/**
	* @var int
	*/
	private $sale_id;
	
	/**
	* @var int
	*/
	private $responseCode;
	
	/**
	* @var int
	*/
	private $invoiceTypeCode;
	
	/**
	* @var string
	*/
	private $serieNumero;
	
	/**
	* @var string
	*/
	private $issueDate;
	
	/**
	* @var string
	*/
	private $issueTime;
	
	/**
	* @var string
	*/
	private $documentCurrencyCode;
	
	/**
	* @var int
	*/
	private $supplierDocumentID;
	
	/**
	* @var int
	*/
	private $customerDocumentID;
	
	/**
	* @var string
	*/
	private $customerID;
	
	/**
	* @var string
	*/
	private $customerName;
	
	/**
	* @var double
	*/
	private $taxAmount;
	
	/**
	* @var double
	*/
	private $taxableAmount;
	
	/**
	* @var double
	*/
	private $non_affected;
	
	/**
	* @var double
	*/
	private $exonerated;
	
	/**
	* @var double
	*/
	private $taxSubtotal;
	
	/**
	* @var double
	*/
	private $payableAmount;
	
	/**
	* @var string
	*/
	private $referenceID;
	
	/**
	* @var int
	*/
	private $DocumentTypeCode;
	
	/**
	* @var string
	*/
	private $description;
	
	/**
	* @var int
	*/
	private $user_create;
	
	/**
	* @var string
	*/
	private $date_create;
	
	/**
	* @var int
	*/
	private $user_upgrade;
	
	/**
	* @var string
	*/
	private $date_upgrade;
	
	/**
	* @var int
	*/
	private $flg_response;
	
	/**
	* @var string
	*/
	private $error_code;
	
	/**
	* @var string
	*/
	private $response_descrip;
	
	/**
	* @var string
	*/
	private $digest_value;
	
	/**
	* @var int
	*/
	private $estado;
	
	//************************************************************************
	
	/**
	* @return int
	*/
	public function getId(): int
	{
		return $this->id;
	}
	
	/**
	* @return int
	*/
	public function getSale_id(): int
	{
		return $this->sale_id;
	}
	
	/**
	* @return int
	*/
	public function getResponseCode(): int
	{
		return $this->responseCode;
	}
	
	/**
	* @return int
	*/
	public function getInvoiceTypeCode(): int
	{
		return $this->invoiceTypeCode;
	}
	
	/**
	* @return string
	*/
	public function getSerieNumero(): string
	{
		return $this->serieNumero;
	}
	
	/**
	* @return string
	*/
	public function getIssueDate(): string
	{
		return $this->issueDate;
	}
	
	/**
	* @return string
	*/
	public function getIssueTime(): string
	{
		return $this->issueTime;
	}
	
	/**
	* @return string
	*/
	public function getDocumentCurrencyCode(): string
	{
		return $this->documentCurrencyCode;
	}
	
	/**
	* @return int
	*/
	public function getSupplierDocumentID(): int
	{
		return $this->supplierDocumentID;
	}
	
	/**
	* @return int
	*/
	public function getCustomerDocumentID(): int
	{
		return $this->customerDocumentID;
	}
	
	/**
	* @return string
	*/
	public function getCustomerID(): string
	{
		return $this->customerID;
	}
	
	/**
	* @return int
	*/
	public function getCustomerName(): string
	{
		return $this->customerName;
	}
	
	/**
	* @return double
	*/
	public function getTaxAmount(): string//double
	{
		return $this->taxAmount;
	}
	
	/**
	* @return double
	*/
	public function getTaxableAmount(): string//double
	{
		return $this->taxableAmount;
	}
	
	/**
	* @return double
	*/
	public function getNon_affected(): string//double
	{
		return $this->non_affected;
	}
	
	/**
	* @return double
	*/
	public function getExonerated(): string//double
	{
		return $this->exonerated;
	}
	
	/**
	* @return double
	*/
	public function getTaxSubtotal(): string//double
	{
		return $this->taxSubtotal;
	}
	
	/**
	* @return double
	*/
	public function getPayableAmount(): string//double
	{
		return $this->payableAmount;
	}
	
	/**
	* @return string
	*/
	public function getReferenceID(): string
	{
		return $this->referenceID;
	}
	
	/**
	* @return int
	*/
	public function getDocumentTypeCode(): int
	{
		return $this->DocumentTypeCode;
	}
	
	/**
	* @return string
	*/
	public function getDescription(): string
	{
		return $this->description;
	}
	
	/**
	* @return int
	*/
	public function getUser_create(): int
	{
		return $this->user_create;
	}
	
	/**
	* @return string
	*/
	public function getDate_create(): string
	{
		return $this->date_create;
	}
	
	/**
	* @return int
	*/
	public function getUser_upgrade(): int
	{
		return $this->user_upgrade;
	}
	
	/**
	* @return string
	*/
	public function getDate_upgrade(): string
	{
		return $this->date_upgrade;
	}
	
	/**
	* @return int
	*/
	public function getFlg_response(): int
	{
		return $this->flg_response;
	}
	
	/**
	* @return string
	*/
	public function getError_code(): string
	{
		return $this->error_code;
	}
	
	/**
	* @return string
	*/
	public function getResponse_descrip(): string
	{
		return $this->response_descrip;
	}
	
	/**
	* @return string
	*/
	public function getDigest_value(): string
	{
		return $this->digest_value;
	}
	
	/**
	* @return int
	*/
	public function getEstado(): int
	{
		return $this->estado;
	}
	
	//************************************************************************
	
	/**
	* @param int $id
	* @return NoteCreditModel
	*/
	public function setId(int $id)//: NoteCreditModel
	{
		$this->id = $id;
	}
	
	/**
	* @param int $sale_id
	* @return NoteCreditModel
	*/
	public function setSale_id(int $sale_id)//: NoteCreditModel
	{
		$this->sale_id = $sale_id;
	}
	
	/**
	* @param int $responseCode
	* @return NoteCreditModel
	*/
	public function setResponseCode(int $responseCode)//: NoteCreditModel
	{
		$this->responseCode = $responseCode;
	}
	
	/**
	* @param int $invoiceTypeCode
	* @return NoteCreditModel
	*/
	public function setInvoiceTypeCode(int $invoiceTypeCode)//: NoteCreditModel
	{
		$this->invoiceTypeCode = $invoiceTypeCode;
	}
	
	/**
	* @param string $serieNumero
	* @return NoteCreditModel
	*/
	public function setSerieNumero(string $serieNumero)//: NoteCreditModel
	{
		$this->serieNumero = $serieNumero;
	}
	
	/**
	* @param string $issueDate
	* @return NoteCreditModel
	*/
	public function setIssueDate(string $issueDate)//: NoteCreditModel
	{
		$this->issueDate = $issueDate;
	}
	
	/**
	* @param string $issueTime
	* @return NoteCreditModel
	*/
	public function setIssueTime(string $issueTime)//: NoteCreditModel
	{
		$this->issueTime = $issueTime;
	}
	
	/**
	* @param string $documentCurrencyCode
	* @return NoteCreditModel
	*/
	public function setDocumentCurrencyCode(string $documentCurrencyCode)//: NoteCreditModel
	{
		$this->documentCurrencyCode = $documentCurrencyCode;
	}
	
	/**
	* @param string $supplierDocumentID
	* @return NoteCreditModel
	*/
	public function setSupplierDocumentID(int $supplierDocumentID)//: NoteCreditModel
	{
		$this->supplierDocumentID = $supplierDocumentID;
	}
	
	/**
	* @param string $customerDocumentID
	* @return NoteCreditModel
	*/
	public function setCustomerDocumentID(int $customerDocumentID)//: NoteCreditModel
	{
		$this->customerDocumentID = $customerDocumentID;
	}
	
	/**
	* @param string $customerID
	* @return NoteCreditModel
	*/
	public function setCustomerID(string $customerID)//: NoteCreditModel
	{
		$this->customerID = $customerID;
	}
	
	/**
	* @param string $customerName
	* @return NoteCreditModel
	*/
	public function setCustomerName(string $customerName)//: NoteCreditModel
	{
		$this->customerName = $customerName;
	}
	
	/**
	* @param string $taxAmount
	* @return NoteCreditModel
	*/
	public function setTaxAmount(/*double*/ string $taxAmount)//: NoteCreditModel
	{
		$this->taxAmount = $taxAmount;
	}
	
	/**
	* @param string $taxableAmount
	* @return NoteCreditModel
	*/
	public function setTaxableAmount(/*double*/ string $taxableAmount)//: NoteCreditModel
	{
		$this->taxableAmount = $taxableAmount;
	}
	
	/**
	* @param string $non_affected
	* @return NoteCreditModel
	*/
	public function setNon_affected(/*double*/ string $non_affected)//: NoteCreditModel
	{
		$this->non_affected = $non_affected;
	}
	
	/**
	* @param string $exonerated
	* @return NoteCreditModel
	*/
	public function setExonerated(/*double*/ string $exonerated)//: NoteCreditModel
	{
		$this->exonerated = $exonerated;
	}
	
	/**
	* @param string $taxSubtotal
	* @return NoteCreditModel
	*/
	public function setTaxSubtotal(/*double*/ string $taxSubtotal)//: NoteCreditModel
	{
		$this->taxSubtotal = $taxSubtotal;
	}
	
	/**
	* @param string $payableAmount
	* @return NoteCreditModel
	*/
	public function setPayableAmount(/*double*/ string $payableAmount)//: NoteCreditModel
	{
		$this->payableAmount = $payableAmount;
	}
	
	/**
	* @param string $referenceID
	* @return NoteCreditModel
	*/
	public function setReferenceID(string $referenceID)//: NoteCreditModel
	{
		$this->referenceID = $referenceID;
	}
	
	/**
	* @param string $DocumentTypeCode
	* @return NoteCreditModel
	*/
	public function setDocumentTypeCode(int $DocumentTypeCode)//: NoteCreditModel
	{
		$this->DocumentTypeCode = $DocumentTypeCode;
	}
	
	/**
	* @param string $description
	* @return NoteCreditModel
	*/
	public function setDescription(string $description)//: NoteCreditModel
	{
		$this->description = $description;
	}
	
	/**
	* @param string $user_create
	* @return NoteCreditModel
	*/
	public function setUser_create(int $user_create)//: NoteCreditModel
	{
		$this->user_create = $user_create;
	}
	
	/**
	* @param string $date_create
	* @return NoteCreditModel
	*/
	public function setDate_create(string $date_create)//: NoteCreditModel
	{
		$this->date_create = $date_create;
	}
	
	/**
	* @param string $user_upgrade
	* @return NoteCreditModel
	*/
	public function setUser_upgrade(int $user_upgrade)//: NoteCreditModel
	{
		$this->user_upgrade = $user_upgrade;
	}
	
	/**
	* @param string $date_upgrade
	* @return NoteCreditModel
	*/
	public function setDate_upgrade(string $date_upgrade)//: NoteCreditModel
	{
		$this->date_upgrade = $date_upgrade;
	}
	
	/**
	* @param int $flg_response
	* @return NoteCreditModel
	*/
	public function setFlg_response(int $flg_response)//: NoteCreditModel
	{
		$this->flg_response = $flg_response;
	}
	
	/**
	* @param string $error_code
	* @return NoteCreditModel
	*/
	public function setError_code(string $error_code)//: NoteCreditModel
	{
		$this->error_code = $error_code;
	}
	
	/**
	* @param string $response_descrip
	* @return NoteCreditModel
	*/
	public function setResponse_descrip(string $response_descrip)//: NoteCreditModel
	{
		$this->response_descrip = $response_descrip;
	}
	
	/**
	* @param string $digest_value
	* @return NoteCreditModel
	*/
	public function setDigest_value(string $digest_value)//: NoteCreditModel
	{
		$this->digest_value = $digest_value;
	}
	
	/**
	* @param int $estado
	* @return NoteCreditModel
	*/
	public function setEstado(int $estado)//: NoteCreditModel
	{
		$this->estado = $estado;
	}
	
	
}