<?php

namespace App\DAO\MySQL\CodeBD;
use App\Models\MySQL\CodeyGenerateSale\SaleModel;
use App\Models\MySQL\CodeyGenerateSale\SaleItemsModel;
use App\Models\MySQL\CodeyGenerateBusiness\BusinessModel;

class SaleDAO extends Conexao
{
	
	public function __construct()
	{
		parent::__construct();
	}
	
	public function valid_Exchange(array $datos_emp): array
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('CALL `type_Exchange`(
			);');
			
			$statement->execute([
			]);
			
			$row = $statement->fetchAll(\PDO::FETCH_ASSOC);
			$statement->closeCursor();
			return $row;
			
		}catch(PDOException $e){
			$row[0] =0;
			
			return $row;
		}
		
	}
	
	public function regist_sale(SaleModel $sale, array $sale_items, $ruc, $method_paid, array $datos_emp): array
	{
		   
		for($contador=1; $contador < count($sale_items) + 1; $contador++){
			$sale_items[$contador]['product_id']="0";
			$sale_items[$contador]['discount']="0.00";
			$sale_items[$contador]['item_discount']="0.00";
			$sale_items[$contador]['prr_discount']="0.00";
			$sale_items[$contador]['real_unit_price']="0.00";
			$sale_items[$contador]['currency_cost']=$sale->getCurrency();
			$sale_items[$contador]['cost']="0.00";
		}
		
		$datos_items['items']= $sale_items;
		
		if($sale->getExpiration_date()==""){
			$value_date_expire=null;}else{
			$value_date_expire=$sale->getExpiration_date();}
		
		$datosITEMS = json_encode($datos_items);
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('CALL sp_ventas_registrar_venta (
				:dateP,
				:local_idP,
				:warehouse_idP,
				:customer_idP,
				:customer_nameP,
				:document_typeP,
				:currencyP,
				:exchangeP,
				:affectedP,
				:non_affectedP,
				:exoneratedP,
				:totalP,
				:product_discountP,
				:order_discount_idP,
				:order_discountP,
				:total_discountP,
				:product_taxP,
				:order_tax_idP,
				:order_taxP,
				:total_taxP,
				:tax_ICBPERP,
				:mult_ICBPERP,
				:subtotalP,
				:amountP,
				:grand_totalP,
				:total_itemsP,
				:total_quantityP,
				:paidP,
				:created_byP,
				null,
				null,
				:noteP,
				:statusP,
				:roundingP,
				:attachmentP,
				:expiration_dateP,
				:canal_idP,
				:custom_field_1P,
				:custom_field_2P,
				:custom_field_3P,
				:invoice_idP,
				:flg_responseP,
				:error_codeP,
				:response_descripP,
				:digest_valueP,
				:estadoP,
				@result_id,
				@result_invoice,
				:itemsSale,
				:QuantityItemsSale,
				:rucP,
				:method_paid
			);');
			
			$statement->execute([
				'dateP' => $sale->getDate(),
				'local_idP' => $sale->getLocal_id(),
				'warehouse_idP' => $sale->getWarehouse_id(),
				'customer_idP' => $sale->getCustomer_id(),
				'customer_nameP' => $sale->getCustomer_name(),
				'document_typeP' => $sale->getDocument_type(),
				'currencyP' => $sale->getCurrency(),
				'exchangeP' => $sale->getExchange(),
				'affectedP' => $sale->getAffected(),
				'non_affectedP' => $sale->getNon_affected(),
				'exoneratedP' => $sale->getExonerated(),
				'totalP' => $sale->getTotal(),
				'product_discountP' => $sale->getProduct_discount(),
				'order_discount_idP' => $sale->getOrder_discount_id(),
				'order_discountP' => $sale->getOrder_discount(),
				'total_discountP' => $sale->getTotal_discount(),
				'product_taxP' => $sale->getProduct_tax(),
				'order_tax_idP' => $sale->getOrder_tax_id(),
				'order_taxP' => $sale->getOrder_tax(),
				'total_taxP' => $sale->getTotal_tax(),
				'tax_ICBPERP' => $sale->getTax_ICBPER(),
				'mult_ICBPERP' => $sale->getMult_ICBPER(),
				'subtotalP' => $sale->getSubtotal(),
				'amountP' => $sale->getAmount(),
				'grand_totalP' => $sale->getGrand_total(),
				'total_itemsP' => $sale->getTotal_items(),
				'total_quantityP' => $sale->getTotal_quantity(),
				'paidP' => $sale->getPaid(),
				'created_byP' => $sale->getCreated_by(),
				//'updated_byP' => $sale->getUpdated_by(),
				//'updated_atP' => $sale->getUpdated_at(),
				'noteP' => $sale->getNote(),
				'statusP' => $sale->getStatus(),
				'roundingP' => $sale->getRounding(),
				'attachmentP' => $sale->getAttachment(),
				'expiration_dateP' => $value_date_expire,
				'canal_idP' => $sale->getCanal_id(),
				'custom_field_1P' => $sale->getCustom_field_1(),
				'custom_field_2P' => $sale->getCustom_field_2(),
				'custom_field_3P' => $sale->getCustom_field_3(),
				'invoice_idP' => $sale->getInvoice_id(),
				'flg_responseP' => $sale->getFlg_response(),
				'error_codeP' => $sale->getError_code(),
				'response_descripP' => $sale->getResponse_descrip(),
				'digest_valueP' => $sale->getDigest_value(),
				'estadoP' => $sale->getEstado(),
				'itemsSale' => $datosITEMS,
				'QuantityItemsSale' => (count($sale_items) + 1),
				'rucP' => (String)$ruc,
				'method_paid'=>$method_paid
			]);
			
			$statement->closeCursor();
			$row = $conexion->query("SELECT @result_id AS result_id, @result_invoice AS result_invoice")->fetch(\PDO::FETCH_ASSOC);
			$sale->setId($row['result_id']);
			$sale->setInvoice_id($row['result_invoice']);
			//***********registro de items (REEMPLAZAR CUANDO SE TENGA ULTIMA VERSION MySQL - solo comentar)********************
			/*$s_items =new SaleItemsModel();
			
			
			if($sale->getId()> 0){
			
				for($contador=1; $contador < count($sale_items) + 1; $contador++){
				
					$s_items->setSale_id($sale->getId());
					$s_items->setProduct_id(0);
					$s_items->setCode($sale_items[$contador]['code']);
					$s_items->setName($sale_items[$contador]['name']);
					$s_items->setQuantity($sale_items[$contador]['Quantity']);
					$s_items->setUnit_price($sale_items[$contador]['Unit_price']);
					$s_items->setAffect_price($sale_items[$contador]['Affect_price']);
					$s_items->setNon_affected_price($sale_items[$contador]['Non_affected_price']);
					$s_items->setExonerated_price($sale_items[$contador]['Exonerated_price']);
					$s_items->setDiscount("0.00");//$sale_items[$contador]['Discount']);
					$s_items->setItem_discount("0.00");//$sale_items[$contador]['Item_discount']);
					$s_items->setPrr_discount("0.00");//$sale_items[$contador]['Prr_discount']);
					$s_items->setTax($sale_items[$contador]['Tax']);
					$s_items->setItem_tax($sale_items[$contador]['Item_tax']);
					$s_items->setIgv($sale_items[$contador]['Igv']);
					$s_items->setTax_ICBPER($sale_items[$contador]['Tax_ICBPER']);
					$s_items->setQuantity_ICBPER($sale_items[$contador]['Quantity_ICBPER']);
					$s_items->setSubtotal($sale_items[$contador]['Subtotal']);
					$s_items->setReal_unit_price("0.00");//$sale_items[$contador]['Real_unit_price']);
					$s_items->setCurrency_cost($sale->getCurrency());
					$s_items->setCost("0.00");//$sale_items[$contador]['Cost']);
					$s_items->setTax_method(0);//$sale_items[$contador]['Tax_method']);
					
					$this->regist_sale_items($s_items, $datos_emp);
					
				}
			}*/
			//****************************************************************
			$respuestaSol[0]=$sale->getInvoice_id();
			$respuestaSol[1]=$sale->getId();
			
			return $respuestaSol;
		
	}
	
	public function regist_sale_items(SaleItemsModel $item, $datos_emp){
		$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
		$statement = $conexion->prepare('INSERT INTO  tec_sale_items VALUES(
		null,
		:sale_id,
		:product_id,
		:code,
		:name,
		:quantity,
		:unit_price,
		:affect_price,
		:non_affected_price,
		:exonerated_price,
		:discount,
		:item_discount,
		:prr_discount,
		:tax,
		:item_tax,
		:igv,
		:tax_ICBPER,
		:quantity_ICBPER,
		:subtotal,
		:real_unit_price,
		:currency_cost,
		:cost,
		:tax_method
		);');
		
		$statement->execute([
			'sale_id' => $item->getSale_id(),
			'product_id' => $item->getProduct_id(),
			'code' => $item->getCode(),
			'name' => $item->getName(),
			'quantity' => $item->getQuantity(),
			'unit_price' => $item->getUnit_price(),
			'affect_price' => $item->getAffect_price(),
			'non_affected_price' => $item->getNon_affected_price(),
			'exonerated_price' => $item->getExonerated_price(),
			'discount' => $item->getDiscount(),
			'item_discount' => $item->getItem_discount(),
			'prr_discount' => $item->getPrr_discount(),
			'tax' => $item->getTax(),
			'item_tax' => $item->getItem_tax(),
			'igv' => $item->getIgv(),
			'tax_ICBPER' => $item->getTax_ICBPER(),
			'quantity_ICBPER' => $item->getQuantity_ICBPER(),
			'subtotal' => $item->getSubtotal(),
			'real_unit_price' => $item->getReal_unit_price(),
			'currency_cost' => $item->getCurrency_cost(),
			'cost' => $item->getCost(),
			'tax_method' => $item->getTax_method()

		]);
		
		
	}
	
	public function modificar_sale_Xml(SaleModel $sale, $datos_emp)
	{
		
		try{
		
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('CALL `update_Xml_sale`(
			:idP,
			:flg_responseP,
			:error_codeP,
			:response_descripP,
			:digest_valueP
			);');
			
			$statement->execute([
			'idP' => $sale->getId(),
			'flg_responseP' => $sale->getFlg_response(),
			'error_codeP' => $sale->getError_code(),
			'response_descripP' => $sale->getResponse_descrip(),
			'digest_valueP' => $sale->getDigest_value(),
			]);
			
		}catch(PDOException $e){
			
		}
		
	}
	
	public function regist_send_invoice(array $data_send_invoice, $id, $datos_emp)
	{
		
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);
			$statement = $conexion->prepare('CALL `register_Send_invoice`(
			:issue_dateP,
			:file_nameP,
			:reference_dateP,
			:processed_dateP,
			:typeP,
			:flg_responseP,
			:error_codeP,
			:response_descripP,
			:statusP,
			:uCreaP,
			:fCreaP,
			:estadoP,
			:sale_idP
			);');
			
			$statement->execute([
			'issue_dateP' => $data_send_invoice['date'],
			'file_nameP' => $data_send_invoice['file_name'],
			'reference_dateP' => $data_send_invoice['date'],
			'processed_dateP' => $data_send_invoice['date'],
			'typeP'=> "RF",
			'flg_responseP' => $data_send_invoice['flg_response'],
			'error_codeP' => $data_send_invoice['error_code'],
			'response_descripP' => $data_send_invoice['response_descrip'],
			'statusP' => $data_send_invoice['status'],
			'uCreaP' => "1",
			'fCreaP' => $data_send_invoice['date']." ".$data_send_invoice['hora'],
			'estadoP' => 1,
			'sale_idP' => $id
			]);
			
		}catch(PDOException $e){
			
		}
		
	}
	public function regist_sale_file($invoice_id, $file_name, $datos_emp)
	{
		try{
			$conexion = Conexao::conectarBd($datos_emp['host_BD'],
							$datos_emp['BD_sistema'],
							$datos_emp['usuario_BD'],
							$datos_emp['password_BD']);

			$statement = $conexion->prepare('CALL `register_sale_file`(:invoice_idP,:file_nameP);');
			
			$statement->execute([
			'invoice_idP' =>(string)$invoice_id,
			'file_nameP' =>(string)$file_name
			]);
			
		}catch(PDOException $e){
			
		}
		
	}
	
	
}